% This function accepts binding data (Y) and returns a vector, Yhat, of fitted
% binding values corresponding to the original ligand concentration data.
% It also returns two sets of fitting parameters f, KD, and n, one set for each
% of the two assumed transitions. Here f is fractional saturation at the transition.
% The model Y = f1 * L^n1/(L^n1 + KD1^n) +  f2 * L^n2/(L^n2 + KD2^n) is used for this fit.

  function Yhat = Fit_KDn(C, x)
     
     f1 = C(1);
     KD1 = C(2);
     n1 = C(3);
     f2 = C(4);   
     KD2 = C(5);
     n2 = C(6);  
     

     Yhat = f1.*(x.^n1)./(x.^n1 + KD1.^n1) + f2.*(x.^n2)./(x.^n2 + KD2.^n2);



